//===============================================================================================
// Image buttons
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

function renderBtn( id, act, src, hoverSrc, dwnSrc, disabledSrc, tip )
{
	var kImgBase = "../img/";
	
	var s = '<a';
	
	if( id )  s += appendAttr( "id", id );	
	if( act ) s += appendAttr( "href", "javascript:if(!this.meDisabled||this.meDisabled!='yes')" + act );	
	if( src ) s += appendAttr( "normalSrc", kImgBase+src );
		
	if( hoverSrc )
	{
		s += appendAttr( "hoverSrc", kImgBase+hoverSrc );
		s += appendAttr( "onmouseover", "onImgBtnHover(this)" );
		s += appendAttr( "onmouseout", "onImgBtnHover(this)" );
	}	
	
	if( dwnSrc )
	{
		s += appendAttr( "dwnSrc", kImgBase+dwnSrc );
		s += appendAttr( "onmousedown", "onImgBtnHover(this)" );
		s += appendAttr( "onmouseup", "onImgBtnHover(this)" );
	}	

	if( disabledSrc )
	{
		// disable the button by default
		s += appendAttr( "disabledSrc", kImgBase+disabledSrc );
		s += appendAttr( "meDisabled", "yes" );
		s += appendAttr( "style", "cursor:default" );
	}

	if( tip ) s += appendAttr( "title", tip );
	
	s += '><img align="absmiddle" border="0"';
	
	if( disabledSrc ) s += appendAttr( "src", kImgBase+disabledSrc );
	else if( src ) s += appendAttr( "src", kImgBase+src );
	
	s += '></a>';
	return s;
}

//-----------------------------------------------------------------------------
function appendBtn( id, act, src, hoverSrc, dwnSrc, disabledSrc, tip )
{
	document.write(renderBtn(id,act,src,hoverSrc,dwnSrc,disabledSrc,tip));
}

//-----------------------------------------------------------------------------
function disableBtn( id )
{
	var e = document.getElementById( id );
	if( !e ) return;	
	if( e.disabledSrc )
	{
		e.firstChild.src = e.disabledSrc;
		e.meDisabled = "yes"
	}	
}

//-----------------------------------------------------------------------------
// make the button appear pressed and disable it.
function pressAndDisableBtn( id )
{
	var e = document.getElementById( id );
	if( !e ) return;	
	if( e.dwnSrc )
	{
		e.firstChild.src = e.dwnSrc;
		e.meDisabled = "yes"
	}	
}

//-----------------------------------------------------------------------------
function enableBtn( id )
{
	var e = document.getElementById( id );
	if( !e ) return;	
	if( e.normalSrc )
	{
		e.firstChild.src = e.normalSrc;
		e.meDisabled = "no"
		e.style.cursor = "hand";
	}
}

//-----------------------------------------------------------------------------
function onImgBtnHover(e)
{
	if( e.meDisabled && e.meDisabled == "yes" ) return;
	
	var evt = window.event;
	if (!evt) return;
	switch( evt.type )
	{
		case "mouseover":
			if(e.hoverSrc) e.firstChild.src = e.hoverSrc;
			break;

		case "mouseup":
		case "mouseout":
			if(e.normalSrc) e.firstChild.src = e.normalSrc;
			break;

		case "mousedown":
			if(e.dwnSrc) e.firstChild.src = e.dwnSrc;
			break;
	}
}
